/*
 * C (c) 2017 Broadcom Corp. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 * Author: Deepak Khungar <deepak.khungar@broadcom.com>
 *
 * Description: Main header of bnxt_lfc driver
 */

#ifndef BNXT_LFC_H
#define BNXT_LFC_H

#define DRIVER_NAME		"bnxt_lfc"
#define DRIVER_AUTHOR		"Kshitij Soni <kshitij.soni@broadcom.com>"
#define DRIVER_DESC		"BNXT LFC driver"
#define DRIVER_VERSION "214.0.131.0"
/* Assuming that no HWRM command requires more than 10 DMA address
 * as input requests.
 */
#define MAX_NUM_DMA_INDICATIONS	10
#define MAX_DMA_MEM_SIZE		0x8000 /*32K*/

/* To prevent mismatch between bnxtnvm user application and bnxt_lfc
 * keeping the max. size as 512.
 */
#define BNXT_LFC_MAX_HWRM_REQ_LENGTH HWRM_MAX_REQ_LEN
#define BNXT_LFC_MAX_HWRM_RESP_LENGTH (512)

#define BNXT_NVM_FLUSH_TIMEOUT	((DFLT_HWRM_CMD_TIMEOUT) * 100)
#define BNXT_LFC_DEV_NAME	"bnxt_lfc"
#define DRV_NAME		BNXT_LFC_DEV_NAME

#define BNXT_LFC_ERR(dev, fmt, arg...)					\
	dev_err(dev, "%s: %s:%d: "fmt "\n",				\
		DRV_NAME, __func__,					\
		__LINE__, ##arg)					\

#define BNXT_LFC_WARN(dev, fmt, arg...)					\
	dev_warn(dev, "%s: %s:%d: "fmt "\n",				\
		DRV_NAME, __func__,					\
		__LINE__, ##arg)					\

#define BNXT_LFC_INFO(dev, fmt, arg...)					\
	dev_info(dev, "%s: %s:%d: "fmt "\n",				\
		DRV_NAME, __func__,					\
		__LINE__, ##arg)					\

#define BNXT_LFC_DEBUG(dev, fmt, arg...)				\
	dev_dbg(dev, "%s: %s:%d: "fmt "\n",				\
		DRV_NAME, __func__,					\
		__LINE__, ##arg)					\

struct bnxt_lfc_dev {
	struct pci_dev *pdev;

	dev_t d_dev;
	struct class *d_class;
	struct cdev c_dev;

	struct bnxt *bp;
	struct bnxt_en_dev *en_dev;

	struct file_operations fops;
	struct bnxt_ulp_ops uops;

	struct mutex bnxt_lfc_lock;
	/* dma_virt_addr to hold the virtual address
	 * of the DMA memory.
	 */
	void *dma_virt_addr[MAX_NUM_DMA_INDICATIONS];
	/* dma_addr to hold the DMA addresses*/
	dma_addr_t dma_addr[MAX_NUM_DMA_INDICATIONS];
	uint32_t bnxt_en_version;
};
#endif /*BNXT_LFC_H*/
